/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/


package cnrg.itx.datax.devices;

import java.io.*;

/**
 * Client to test the FEC buffer implementation.
 */
class FECBufferTest
{
	private static BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
	
	public static void main(String[] args)
	{	
		System.out.println("Testing FECBuffer");

		byte[] buf1 = new byte[100];
		byte[] buf2 = new byte[100];
		byte[] buf3 = new byte[100];
		
		for (int i=0; i<100; i++)
		{
			buf1[i] = (byte)i;
			buf2[i] = (byte)(100-i);
			buf3[i] = (byte)(100+i);
		}
		
		FECBuffer buffer = new FECBuffer(100);
		
		printArray(buffer.pack(buf1));
		printArray(buffer.pack(buf2));
		byte[] buf = buffer.pack(buf3);
		
		printArray(buf);
		
		printArray(buffer.unpack(buf));
		
		for (int i=0; i<buffer.getNumFECPackets(); i++)
		{
			System.out.println("Printing buffer " + (i+1));
			printArray(buffer.getBuffer(i));
		}
	}
	
	private static void printArray(byte[] buffer)
	{
		for (int i=0; i<buffer.length; i++)
			System.out.print((0xff & buffer[i]) + " ");
		
		System.out.println("\n\nPress Enter to continue...");
		
		try
		{
			in.readLine();
		}
		catch (Exception e)
		{
		}
	}
}
